% This function computes a simple fuzzy system with three inputs, one output,
% and a total of p^3 rules using Gaussian membership functions. Note that
% this fuzzy system's implementation is difficult to generalize, so you may
% want to consider implementing a general purpose fuzzy system.

function [Fu,zeta] = Fu_app(z, theta, alpha)

% number of m.f.'s per input (note that for simplicity the same number is
% used for all inputs)
global p;

% generate centers for the m.f.'s
cents = linspace(-1,1,p);
for i=1:p
    for j=1:p
        for k=1:p
            c_z1((i-1)*p^2+(j-1)*p+k) = cents(i);
            c_z2((i-1)*p^2+(j-1)*p+k) = cents(j);
            c_z3((i-1)*p^2+(j-1)*p+k) = cents(k);
        end
    end
end

% spread for all z1 m.f.'s
sigma_z1 = 0.5;
% spread for all z2 m.f.'s
sigma_z2 = 0.5;
% spread for all z3 m.f.'s
sigma_z3 = 0.5;

% scale inputs
z1 = z(1)*alpha(1);
z2 = z(2)*alpha(2);
z3 = z(3)*alpha(3);
% saturate inputs
z1=sat(z1);
z2=sat(z2);
z3=sat(z3);

% compute mu_j (inferences)
mu = exp(-((z1-c_z1)/sigma_z1).^2).*exp(-((z2-c_z2)/sigma_z2).^2).*exp(-((z3-c_z3)/sigma_z3).^2);
% compute zeta
zeta = mu' / sum(mu);
% compute fuzzy system's output
Fu = theta'*zeta;

% finally, scale output
Fu = Fu*alpha(4);